package fr.asip.cps3.exemple.modele.ecouteurs;

import java.util.EventListener;

import fr.asip.cps3.exemple.modele.Application;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionVue;
import fr.asip.cps3.exemple.modele.resultats.Resultat;

/**
 * Interface couteur de l'application
 *
 */
public interface ApplicationEcouteur extends EventListener {
	
	/**
	 * Gre l'affichage du rsultat
	 * @param resultat Rsultat  afficher
	 * @throws ExceptionVue 
	 */
	public void afficheResultat(Resultat resultat) throws ExceptionVue;

	/**
	 * Gre le changement de librairie
	 * @param description Description de la nouvelle librairie
	 */
	public void chargementLibrairie(String description);

	/**
	 * Gre la notification de problme de chargement de librairie
	 * @param typeException Le type d'exception rencontre
	 * @param application L'application
	 */
	public void problemeChargementLibrairie(int typeException, Application application);

	/**
	 * Mise  jour des menus
	 * @param application L'application
	 */
	public void majMenus(Application application);

	/**
	 * Gre l'affichage de l'cran
	 * @param typeEcran Le type d'cran  afficher
	 * @throws ExceptionVue 
	 */
	public void afficheEcran(int typeEcran) throws ExceptionVue;

	/**
	 * Gre l'affichage de l'cran avec prise en compte d'un objet ncessaire  l'opration
	 * @param typeEcran Le type d'cran  afficher
	 * @param objet Objet ncessaire pour l'opration
	 * @throws ExceptionVue 
	 */
	public void afficheEcran(int typeEcran,Object objet) throws ExceptionVue;
	
	/**
	 * Gre l'affichage de l'exception
	 * @param exception L'exception  afficher
	 */
	public void afficheException(Exception exception);
	
	/**
	 * Demande  l'utilisateur de connecter un lecteur
	 * @return Rponse utilisateur
	 */
	public int demandeConnexionLecteur();
	
	/**
	 * Demande  l'utilisateur d'insrer une carte supporte
	 * @return Rponse utilisateur
	 */
	public int demandeInsertionCarte();

	/**
	 * Demande  l'utilisateur de saisir le code porteur
	 * 
	 * @param nbEssais Le type de saisie ( N tentatives,  3 tentatives)
	 * @param conformiteCodePorteur Flag permettant de dterminer le message  afficher
	 * @param numeroSerieCarte Numro de srie de la carte
	 * @return Tableau de 2 lments, contenant le choix utilisateur [0] et le code porteur saisi [1]
	 */
	public Object[] demandeSaisieCodePorteur(long nbEssais, long conformiteCodePorteur, String numeroSerieCarte);	

	/**
	 * Demande  l'utilisateur de recycler le code porteur
	 * 
	 * @param nbEssais Flag permettant de dterminer le message  afficher concernant le nombre d'essai
	 * @param conformiteCodeDeblocage Etat de conformit du code de dblocage
	 * @param conformiteCodePorteur Etat de conformit du code porteur
	 * @param numeroSerieCarte Numro de srie de la carte
	 * @return Tableau de 4 lments, contenant le choix utilisateur [0] et le code de dblocage [1], le 1er code porteur saisi [2] et le 2eme code porteur saisi [3]
	 */
	public Object[] demandeRecyclageCodePorteur(long nbEssais, long conformiteCodeDeblocage, long conformiteCodePorteur, String numeroSerieCarte);		
	
	/**
	 * Demande de choix du nombre d'essais possibles avant blocage du code porteur
	 * @return Rponse utilisateur
	 */
	public int demandeChoixNbEssaisPossiblesAvantBlocageCodePorteur();

	/**
	 * Demande d'action lecteur (retrait/connexion) ou carte (retrait/insertion)
	 *
	 * @param typeAction Le type d'action  demander
	 * @param numeroSerieCarte Numro de srie de la carte
	 * @return Rponse utilisateur
	 */	
	public int demandeActionLecteurCarte(int typeAction, String numeroSerieCarte);

	/**
	 * Dclenche l'alerte de carte retrouve
	 */	
	public void declencheAlerteCarteRetrouvee();
	
	/**
	 * Dclenche l'alerte de carte retrouve
	 * 
	 * @param valeur Valeur  modifier
	 * @return Tableau de 2 lments, contenant le choix utilisateur [0] et le valeur de l'attribut modifie [1]
	 */	
	public Object[] declencheDemandeModificationObjetDonneesApplicatives(byte[] valeur);
	
}
